/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
//
// this file is specific to the crosshair, since we use several crosshairs
//
#include "quakedef.h"


float glowcos[17] = 
{
	 1.000000f,
	 0.923880f,
	 0.707105f,
	 0.382680f,
	 0.000000f,
	-0.382680f,
	-0.707105f,
	-0.923880f,
	-1.000000f,
	-0.923880f,
	-0.707105f,
	-0.382680f,
	 0.000000f,
	 0.382680f,
	 0.707105f,
	 0.923880f,
	 1.000000f
};


float glowsin[17] = 
{
	 0.000000f,
	 0.382680f,
	 0.707105f,
	 0.923880f,
	 1.000000f,
	 0.923880f,
	 0.707105f,
	 0.382680f,
	-0.000000f,
	-0.382680f,
	-0.707105f,
	-0.923880f,
	-1.000000f,
	-0.923880f,
	-0.707105f,
	-0.382680f,
	 0.000000f
};

void R_DrawGlows(entity_t *e)
{
	vec3_t	lightorigin;	// Origin of torch.
	vec3_t	v;				// Vector to torch.
	float	radius;			// Radius of torch flare.
	float	distance;		// Vector distance to torch.
	float	intensity;		// Intensity of torch flare.
	int			i;
	model_t		*clmodel;

	if (gl_fogenable.value)
	{
		glDisable(GL_FOG);
	}	

	clmodel = e->model;

	// NOTE: this isn't centered on the model
	VectorCopy(e->origin, lightorigin);	

	//set radius based on what model we are doing here
	if ((!strcmp (clmodel->name, "progs/missile.mdl")) ||
		(!strcmp (clmodel->name, "progs/plasma.mdl")))
	{
		radius = 6.0f;
	}
	else if((!strncmp (clmodel->name, "progs/glow_",11)) ||
			(!strncmp (clmodel->name, "progs/bolt",10))  ||
			(!strcmp (clmodel->name, "progs/laser.mdl")))
	{
		radius = 24.0f;
	}

	VectorSubtract(lightorigin, r_origin, v);

	// See if view is outside the light.
	distance = Length(v);
	if (distance > radius)
	{
		glDepthMask (false);
		glDisable (GL_TEXTURE_2D);
		glBlendFunc (GL_ONE, GL_ONE);
		glPushMatrix();			

		glBegin(GL_TRIANGLE_FAN);

		if (!strncmp (clmodel->name, "progs/glow_",11))
		{	
			glTranslatef(0.0f, 0.0f, 4.0f);
			intensity = (1 - ((1024.0f - distance) * 0.0009765625)) * 0.75;
			glColor3f(1.0f*intensity, 0.7f*intensity, 0.4f*intensity);		
		}
		else if (!strcmp (clmodel->name, "progs/missile.mdl"))
		{
			glColor3f(0.7f, 0.49f, 0.28f);
		}
		else if (!strcmp (clmodel->name, "progs/plasma.mdl"))
		{
			glColor3f(0.0f, 0.7f, 0.0f);
		}
		else if ((!strcmp (clmodel->name, "progs/bolt4.mdl"))	||
				 (!strcmp (clmodel->name, "progs/laser.mdl")))
		{
			glColor3f(0.2f, 0.06f, 0.06f);
		}
		else if ((!strcmp (clmodel->name, "progs/bolt.mdl"))	||
				 (!strcmp (clmodel->name, "progs/bolt2.mdl")) 	||
				 (!strcmp (clmodel->name, "progs/bolt3.mdl")))
		{
			glColor3f(0.02f, 0.02f, 0.2f);				
		}

		v[0] = lightorigin[0] - vpn[0] * radius;
		v[1] = lightorigin[1] - vpn[1] * radius;
		v[2] = lightorigin[2] - vpn[2] * radius;

		glVertex3fv(v);
		glColor3f(0.0f, 0.0f, 0.0f);
		for (i=16; i>=0; i--) 
		{
			v[0] =	lightorigin[0] + vright[0] * glowcos[i] * radius + vup[0] * glowsin[i] * radius;
			v[1] =	lightorigin[1] + vright[1] * glowcos[i] * radius + vup[1] * glowsin[i] * radius;
			v[2] =	lightorigin[2] + vright[2] * glowcos[i] * radius + vup[2] * glowsin[i] * radius;
			glVertex3fv(v);
		}
		glEnd();
		glPopMatrix();
		glColor3f (1,1,1);
		glEnable (GL_TEXTURE_2D);
		glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDepthMask (true);
	}
	if (gl_fogenable.value)
	{
		glEnable(GL_FOG);
	}
}